%-----------------------------------------------
%  UCL : Universit catholique de Louvain
%  CEREM : Centre for research in mechatronics
%  Educational in multibody dynamics - tutorial
%
%  Problem "A five-points suspension"
%  Script Matlab : mbs_susp_simpl.m
%  Author : Paul Fisette
%  Date : november 2006
%  Last update : january 2020
%-----------------------------------------------

%% Initialization and Project Loading

clear variable 
global MBS_user 
 
prjname = 'five_point_suspension_matlab'; 
 
[mbs_data, mbs_info] = mbs_load(prjname,'default'); 
 
 
%%   Coordinate partitioning
MBS_user.process = 'Part' ;
options.part = {'verbose','yes','threshold',1e-8,'rowperm','yes'}; 
[mbs_part,mbs_data] = mbs_exe_part(mbs_data,options.part); 
 
%% Equilibre inverse
MBS_user.process = 'Equil' ;
mbs_data.q(1)=0.3;
options.equil = {'verbose','yes','visualize','no','clearmbsglobal','none',...
        'xeqchoice',{1,'user_model.SUSP.z0'}}; 
[mbs_equil,mbs_data_eq] = mbs_exe_equil(mbs_data,options.equil); 
disp(['Longueur neutre: ' num2str(mbs_data_eq.user_model.SUSP.z0)]);
mbs_data_eq.q0 = mbs_data_eq.q;

%% Sauvegarde des donnes
% mbs_save(mbs_info,mbs_data_eq);

%%   Intgration numrique  partir de l'quilibre
MBS_user.process = 'Dirdyn' ;
options.dirdyn_simulation =  {'motion','simulation','verbose','yes','save2file','yes','renamefile','no',... 
                            'depinteg','no','odemethod','ode45','time',0:0.01:5}; 
[mbs_dirdyn,mbs_data_dirdyn] = mbs_exe_dirdyn(mbs_data_eq,options.dirdyn_simulation); 
 
%%       Rsultat : cinmatique verticale centre roue

N = length(mbs_dirdyn.tsim);
res = zeros(N,4);
for i = 1:N 
    mbs_data.tsim = mbs_dirdyn.tsim(i)'; 
    mbs_data.q = mbs_dirdyn.q(i,:)'; 
    mbs_data.qd = mbs_dirdyn.qd(i,:)'; 
    mbs_data.qdd = mbs_dirdyn.qdd(i,:)'; 
    [sens] = mbs_sensor_five_point_suspension_matlab(mbs_data,0,[],1); 
    res(i,:) = [mbs_data.tsim sens.P(3) sens.V(3) sens.A(3)];
end 
     
figure(1) 
subplot(3,1,1)
plot(res(:,1), res(:,2));grid;title('Vertical position'); 
subplot(3,1,2)
plot(res(:,1), res(:,3));grid;title('Vertical velocity'); 
subplot(3,1,3)
plot(res(:,1), res(:,4));grid;title('Vertical acceleration'); 

%% Closing operations

mbs_rm_allprjpath;                                  % Cleaning of the Matlab project paths
mbs_del_glob('MBS_user','MBS_info','MBS_data');     % Cleaning of the global MBS variables
clear all; clc;                                     % Cleaning of the Matlab workspace

% EOF
